The MIT License (MIT) Copyright (c) 2016 Roman Szewczyk
% Parametri iniziali del modello di JA
mi0=4.*pi.*1e-7;
Ms0=max(max(BmeasT))./mi0;
a0=5;
alpha0=1e-7;
k0=5;
c0=0.8;        

JApoint0=[a0 k0 c0 Ms0 alpha0];
func = @(JApointn) JAn_loops_target(JApointn,JApoint0,HmeasT,BmeasT,1);
options=optimset('Display','iter','MaxFunEvals',500);

tic
JApoint_res=fminsearch(func,[1 1 1 1 1],options);
toc
Ftarget=func(JApoint_res);

BsimT = JAn_loops(JApoint0(1).*JApoint_res(1), JApoint0(2).*JApoint_res(2), JApoint0(3).*JApoint_res(3), ...
JApoint0(4).*JApoint_res(4), JApoint0(5).*JApoint_res(5),HmeasT, 1 );
 
fprintf('Results of optimisation:\n'); 
fprintf('Target function value: Ftarget=%f\n',Ftarget);
fprintf('JA model params: a=%f(A/m), k=%f(A/m), c=%f, Ms=%e(A/m), alpha=%e \n\n',  ...
JApoint0(1).*JApoint_res(1), JApoint0(2).*JApoint_res(2), JApoint0(3).*JApoint_res(3), ...
JApoint0(4).*JApoint_res(4), JApoint0(5).*JApoint_res(5));

% Plot dei risultati
plot(HmeasT, BmeasT,'k',HmeasT,BsimT,'r');
xlabel('H (A/m)');
ylabel('B (T)');
grid;
 
JApoint_optim=JApoint0.*JApoint_res;
